#include <GL/glut.h>
#include <stdlib.h>
#include "shadow.c"
#include "image.c"

int WIDTH = 640;
int HEIGHT = 480;

#define BASESIZE 10.0

#define BASERES 12

#define M_PI 3.14159265358979323846

extern void shadowmatrix(GLfloat [4][4], GLfloat [4], GLfloat [4]);
extern void findplane(GLfloat [4], GLfloat [3], GLfloat [3], GLfloat [3]);

GLfloat baseshadow[4][4];
GLfloat lightpos[4] = {2.3,0.0,3.0,1.0};
GLfloat lightdir[3] = {-2.3,0.0,-3.0};
GLfloat lightalpha = 0.0;

int usetex=1;

GLuint t1id,t2id;
GLuint teapotdlist,basedlist,lightdlist;


static void key(unsigned char k, int x, int y)
	{
	switch(k) 
		{
		case 't':
			usetex=(!usetex);
		break;
		}
	}

void reshape(int w, int h) 
	{
	WIDTH=w;
	HEIGHT=h;
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0,w/(float)h,0.2,40.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glViewport(0,0,w,h);
	}

void drawbase(void)
	{
	int i,j;
	float x,y,dx,dy;

	glBindTexture(GL_TEXTURE_2D,t1id);

	dx =  BASESIZE/BASERES;
	dy = -BASESIZE/BASERES;
	
	for(y = BASESIZE/2.0,j = 0; j < BASERES; y += dy,j++) 
		{
		glBegin(GL_QUAD_STRIP);
		glColor3f(1.0,1.0,1.0);
		glNormal3f(0.0,0.0,1.0);
		for(x=-BASESIZE/2.0,i=0;i<BASERES;x+=dx,i++) 
			{
			glTexCoord2f(x,y);
			glVertex3f(x,y,0.0);

			glTexCoord2f(x,y+dy);
			glVertex3f(x,y+dy,0.0);
			}
		glEnd();
		}
	}

void drawteapot()
	{
	float xrot=0.0;
	float zrot=0.0;

	glPushMatrix();
	glRotatef(lightalpha,0.0,0.0,1.0);
	glMultMatrixf((GLfloat *)baseshadow);
	glRotatef(-lightalpha,0.0,0.0,1.0);

	glTranslatef(0.0,0.0,1.0);
	glRotatef(xrot,1.0,0.0,0.0);
	glRotatef(zrot,0.0,0.0,1.0);

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);

	glColor3f(0.0,0.0,0.0);
	glCallList(teapotdlist);

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	
	if(usetex)
		{
		glEnable(GL_TEXTURE_2D);
		}

	glPopMatrix();

	glPushMatrix();
	glTranslatef(0.0,0.0,1.0);
	glRotatef(xrot,1.0,0.0,0.0);
	glRotatef(zrot,0.0,0.0,1.0);

	glCallList(teapotdlist);
	glPopMatrix();

	xrot+=2.0;
	zrot+=1.0;
	}

void drawlight1(void)
	{
	glPushMatrix();
	glRotatef(lightalpha,0.0,0.0,1.0);
	glLightfv(GL_LIGHT0,GL_POSITION,lightpos);
	glLightfv(GL_LIGHT0,GL_SPOT_DIRECTION,lightdir);

	glPopMatrix();
	}

void drawlight2(void)
	{
	glPushMatrix();
	glRotatef(lightalpha,0.0,0.0,1.0);
	glTranslatef(lightpos[0],lightpos[1],lightpos[2]);

	glDisable(GL_TEXTURE_2D);
	glCallList(lightdlist);
	
	if(usetex)
		{
		glEnable(GL_TEXTURE_2D);
		}
	glPopMatrix();

	lightalpha+=1.0;
	}

void draw(void)
	{
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

	if(usetex)
		{
		glEnable(GL_TEXTURE_2D);
		}
	else
		{
		glDisable(GL_TEXTURE_2D);
		}	

	glEnable(GL_LIGHTING);

	glShadeModel(GL_SMOOTH);

	glPushMatrix();

	gluLookAt(5.0,0.0,1,1.0,1.0,1.0,0.0,0.0,1.0);

	drawlight1();
		glCallList(basedlist);
		drawteapot();
		drawlight2();
	glPopMatrix();

	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_FOG);
	glShadeModel(GL_FLAT);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(-0.5,639.5,-0.5,479.5,-1.0,1.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	reshape(WIDTH,HEIGHT);

	glutSwapBuffers();
	}

void inittextures(void)
	{
	IMAGE *img;
	GLenum gluerr;

	glGenTextures(1,&t1id);
	glBindTexture(GL_TEXTURE_2D,t1id);

	if(!(img=ImageLoad("tile.rgb"))) 
		{
		exit(-1);
		}

	glPixelStorei(GL_UNPACK_ALIGNMENT,4);

	if((gluerr = gluBuild2DMipmaps(GL_TEXTURE_2D, 3, img->sizeX, img->sizeY, GL_RGB,
					 GL_UNSIGNED_BYTE, (GLvoid *)(img->data)))) 
		{
		exit(-1);
		}

	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);

	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST_MIPMAP_LINEAR);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

	glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);

	glGenTextures(1,&t2id);
	glBindTexture(GL_TEXTURE_2D,t2id);

	if(!(img=ImageLoad("bw.rgb"))) 
		{
		exit(-1);
		}

	glPixelStorei(GL_UNPACK_ALIGNMENT,4);

	if((gluerr=gluBuild2DMipmaps(GL_TEXTURE_2D, 3, img->sizeX, img->sizeY, GL_RGB,
			       GL_UNSIGNED_BYTE, (GLvoid *)(img->data)))) 
		{
		exit(-1);
		}

	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);

	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST_MIPMAP_LINEAR);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

	glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
	}

void initlight(void)
	{
	float lamb[4]={0.2,0.2,0.2,1.0};
	float lspec[4]={1.0,1.0,1.0,1.0};

	glLightf(GL_LIGHT0,GL_SPOT_CUTOFF,70.0);
	glLightf(GL_LIGHT0,GL_SPOT_EXPONENT,20.0);
	glLightfv(GL_LIGHT0,GL_AMBIENT,lamb);
	glLightfv(GL_LIGHT0,GL_SPECULAR,lspec);

	glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,20.0);
	glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,lspec);

	glEnable(GL_LIGHT0);
	}

void initdlists(void)
	{
	GLUquadricObj *lcone,*lbase;
	GLfloat plane[4];
	GLfloat v0[3]={0.0,0.0,0.0};
	GLfloat v1[3]={1.0,0.0,0.0};
	GLfloat v2[3]={0.0,1.0,0.0};

	findplane(plane,v0,v1,v2);
	shadowmatrix(baseshadow,plane,lightpos);

	teapotdlist=glGenLists(1);
	glNewList(teapotdlist,GL_COMPILE);
	glRotatef(90.0,1.0,0.0,0.0);
	glCullFace(GL_FRONT);
	glBindTexture(GL_TEXTURE_2D,t2id);
	glutSolidTeapot(0.6);
	glCullFace(GL_BACK);
	glEndList();

	basedlist=glGenLists(1);
	glNewList(basedlist,GL_COMPILE);
	drawbase();
	glEndList();

	lightdlist=glGenLists(1);
	glNewList(lightdlist,GL_COMPILE);
	glDisable(GL_LIGHTING);

	lcone=gluNewQuadric();
	lbase=gluNewQuadric();
	glRotatef(45.0,0.0,1.0,0.0);

	glColor3f(1.0,1.0,1.0);
	glCullFace(GL_FRONT);
	gluDisk(lbase,0.0,0.2,12.0,1.0);
	glCullFace(GL_BACK);

	glColor3f(0.5,0.0,0.0);
	gluCylinder(lcone,0.2,0.0,0.5,12,1);

	gluDeleteQuadric(lcone);
	gluDeleteQuadric(lbase);

	glEnable(GL_LIGHTING);
	glEndList();
	}

int main(int ac, char **av)
	{
	float fogcolor[4]={0.025,0.025,0.025,1.0};

	glutInitWindowPosition(0,0);
	glutInitWindowSize(WIDTH,HEIGHT);
	glutInit(&ac,av);

	glutInitDisplayMode(GLUT_RGB|GLUT_DEPTH|GLUT_DOUBLE);

	glutCreateWindow("Teapot");

	reshape(WIDTH,HEIGHT);

	glShadeModel(GL_SMOOTH);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE);
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_CULL_FACE);
	
	glEnable(GL_FOG);
	glFogi(GL_FOG_MODE,GL_EXP2);
	glFogfv(GL_FOG_COLOR,fogcolor);

	glFogf(GL_FOG_DENSITY,0.04);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

	inittextures();
	initlight();

	initdlists();

	glClearColor(fogcolor[0],fogcolor[1],fogcolor[2],fogcolor[3]);

	glutReshapeFunc(reshape);
	glutDisplayFunc(draw);
	glutKeyboardFunc(key);
	glutIdleFunc(draw);

	glutMainLoop();

	return 0;
	}
